<?php
/* --------------------------------------------------------------
   CurrentUserConfigurationService.php 2020-02-13
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\UserConfiguration\Interfaces;

/**
 * Class CurrentUserConfigurationService
 *
 * @package Gambio\Admin\UserConfiguration\Interfaces
 */
interface CurrentUserConfigurationService
{
    /**
     * @param string $key
     * @param string $default
     *
     * @return string|null
     */
    public function getValue(string $key, string $default = null): ?string;
    
    
    /**
     * @param UserConfiguration $configuration
     */
    public function storeConfiguration(UserConfiguration $configuration): void;
}